﻿Create Procedure dbo.GetEmployees
  @ActiveStatus  int, 
  @HireDate      smalldatetime, 
  @Salaried      bit, 
  @EmployeeCount int output
as 
begin 
  Set nocount on; 

  Declare @Error  int;
  DECLARE @Schema sysname;
  declare @Table  sysname;
  
  set @Schema = N'HumanResources';
  SET @Table = N'Employee';

  If @ActiveStatus is null
    set @ActiveStatus = 1;
  
  -- SELECT Employees
  select 
    e.EmployeeID, 
    c.FirstName, 
    c.LastName, 
    e.Title,
    e.SalariedFlag,
    e.CurrentFlag as "Active"
  FROM 
    HumanResources.Employee e
  inner join 
    Person.Contact c
  on 
    e.ContactID = c.ContactID 
  where    
    e.CurrentFlag = @ActiveStatus
  and
    e.SalariedFlag = @Salaried
  AND (
    e.HireDate >= @HireDate
  Or
    @HireDate is null )
  order by
    e.HireDate desc,
    c.LastName,
    c.FirstName;

  -- Get the total count
  set @EmployeeCount = @@ROWCOUNT; 
  
  -- Insert into the Auditing table
  insert into dbo.TableAudit (
    SchemaName,
    TableName,
    UserName )
  values (
    @Schema,
    @Table,
    ORIGINAL_LOGIN() );

  -- Update the Table Access Tracking table
  update dbo.TableAccess
  set
    UserName = ORIGINAL_LOGIN(),
    AccessDate = getdate()
  where 
    SchemaName = @Schema
  and 
    TableName = @Table;
  
  Return;
END;
